import sys
sys.path.append('./')

from src.optimizers import LocalSGD_Server, LocalSVRG_Server, LocalSARAH_Server, SCAFFOLD_Server


def get_optimizer(optimizer_name, **kargs):
    optimizers = {"lsgd": LocalSGD_Server, #FedAvg
                  "lsvrg": LocalSVRG_Server,
                  "lsarah": LocalSARAH_Server, #BVR-L-SGD
                  "scaffold": SCAFFOLD_Server
                  }
    return optimizers[optimizer_name](**kargs)
